%% Add paths
addpath('State-of-the-art methods/FastProjectedNewton/functions');

%% Read EdgeList from local file 
Edgelist = readtable('Synthetic data Experiments/EdgeList_BA5000.csv');
Edgelist = Edgelist{:,:};

%% Generating the data. If you've already had it, just load it
p = 5000;
adjacency_matrix = sparse(Edgelist(:,1), Edgelist(:,2), ones(size(Edgelist,1),1), p, p);
adjacency_matrix = adjacency_matrix + adjacency_matrix';
adjacency_matrix = full(adjacency_matrix);
eigs = eig(adjacency_matrix);
max_eig = eigs(p);
A = 1.05*max_eig* diag(ones(p,1)) - adjacency_matrix;
inv_A = inv(A);
D = diag(sqrt(diag(inv_A)));
Mtrue = D * A * D;
Ratio = 10;
Repeat_time = 5;
S_list = cell(Repeat_time,1);
for it = 1:Repeat_time
    X = mvnrnd( zeros(p,1), inv(Mtrue), Ratio * p );
    S_list{it} = cov(X);
end
save('S_list.mat','S_list')
  
clear A;
clear D;
clear X;
clear Mtrue;
clear adjacency_matrix;
clear inv_A;
clear eigs;

%% which data to use

NUM_REPEAT = 1;
load('S_list.mat')
S = S_list{NUM_REPEAT};
clear S_list;
 
%% Generate Lambda 
Theta0_mat = zeros(p,p);
for i = 1:p
    for j = 1:p
        if S(i,j)>0 && i~=j
            Theta0_mat(i,j) = -S(i,j)/(S(i,i)*S(j,j)-S(i,j)*S(i,j));
        end
    end
end

chi = 0.01;

Lambda = chi./((abs(Theta0_mat)+0.0001));
for i =1:p
    Lambda(i,i) = 0;
end
 
S_lambda = S - Lambda;
 
%% Time for bridge-block decomposition and initailzation

t0 = tic; 
S_res = max(0, S_lambda);
S_res = S_res - diag(diag(S_res));
S_supp = boolean(S_res); 
G_res = graph(S_supp);
Edge_array = table2array(G_res.Edges); 
bins = biconncomp(G_res);
comp_count = histc(bins, unique(bins)); 
s = [];
t = [];
for i = 1:(length(bins))
    if comp_count(bins(i)) == 1
        s = [s, Edge_array(i, 1)];
        t = [t, Edge_array(i, 2)];
    end
end 
G_res_reduced = rmedge(G_res,s,t);
Final_components = conncomp(G_res_reduced);
Final_components_csize =  histc(Final_components, unique(Final_components));

Subgraphs_index = find(Final_components_csize>1);
Subgraph_list = cell(length(Subgraphs_index),1);

kit = 1;
for k_index = Subgraphs_index
    nodes_indexes = find(Final_components == k_index);
    Subgraph_list{kit} = [];
    for node = nodes_indexes
        Subgraph_list{kit} = union(Subgraph_list{kit},  neighbors(G_res, node));
    end
    kit = kit + 1;
end

Theta_hat = zeros(p,p);

for e = 1:size(Edge_array,1)
   i = Edge_array(e,1);
   j = Edge_array(e,2);
   if Final_components(i) ~= Final_components(j)
       Theta_hat(i,j) = -(S_lambda(i,j))/(S(i,i) * S(j,j) - (S_lambda(i,j) * S_lambda(i,j)));
       Theta_hat(j,i) = Theta_hat(i,j); 
   end 
end

for i = 1:p
    if Final_components_csize(Final_components(i)) == 1
        Theta_ii = 1; 
        for j = neighbors(G_res,i)' 
            Theta_ii = Theta_ii + (S_lambda(i,j) * S_lambda(i,j))/(S(i,i) * S(j,j) - S_lambda(i,j) * S_lambda(i,j));
        end 
        Theta_ii = Theta_ii / S(i,i);
        Theta_hat(i,i) = Theta_ii;
    else 
        Theta_hat(i,i) = 1/S(i,i); 
    end
end

time_pre = toc(t0);
initialized_obj = objective_function(Theta_hat, S_lambda).value;



%% Solve with FPN

opts_FPN.max_iter = 1e4; 
opts_FPN.tol      = 1e-10;
out_FPN           = solver_fpn(S, Lambda, opts_FPN, 0);

obj_FPN = [objective_function(diag(1./diag(S)), S_lambda).value (out_FPN.obj_itr)'];
time_FPN = [0 out_FPN.time_itr'];

clear out_FPN;

%% Solve with FPN with bbd
time_FPN_bbd = [0 time_pre];
obj_FPN_bbd = [objective_function(diag(1./diag(S)), S_lambda).value initialized_obj];

out_FPN_sub_opt = cell(length(Subgraphs_index),1);
for i = 1:length(Subgraphs_index)
    sub_index = Subgraph_list{i};
    S_lambda_sub = S_lambda(sub_index,sub_index);
    S_sub = S(sub_index,sub_index);
    Lambda_sub = Lambda(sub_index,sub_index);
    opts_FPN.max_iter = 1e4; 
    opts_FPN.tol      = 1e-12; 
    out_FPN_sub_opt{i} = solver_fpn(S_sub, Lambda_sub, opts_FPN, 500);
end


for iter = 1:500
    time_sub = 0;
    for i = 1:length(Subgraphs_index)
        if iter == 1
            time_sub = time_sub + out_FPN_sub_opt{i}.time_itr(min(length(out_FPN_sub_opt{i}.obj_itr), iter));
        else
            time_sub = time_sub + out_FPN_sub_opt{i}.time_itr(min(length(out_FPN_sub_opt{i}.obj_itr), iter)) - out_FPN_sub_opt{i}.time_itr(min(length(out_FPN_sub_opt{i}.obj_itr), iter) - 1);
        end 
    end
    total_time = time_FPN_bbd(length(time_FPN_bbd)) + time_sub;
    time_FPN_bbd = [time_FPN_bbd total_time];
    
    for e = 1:size(Edge_array,1)
        i = Edge_array(e,1);
        j = Edge_array(e,2);
        if Final_components(i) == Final_components(j) 
            k = Final_components(i);
            k_id = find(Subgraphs_index == k);
            sub_i = find(Subgraph_list{k_id} == i);
            sub_j = find(Subgraph_list{k_id} == j);
            Theta_sub = out_FPN_sub_opt{k_id}.Theta_hist(:,:, min(length(out_FPN_sub_opt{k_id}.obj_itr), iter));
            
            Theta_hat(i,j) = Theta_sub(sub_i, sub_j);
            Theta_hat(j,i) = Theta_hat(i,j);
        end
    end
    
    for i = 1:p
        if Final_components_csize(Final_components(i)) ~= 1 
            k = Final_components(i);
            k_id = find(Subgraphs_index == k);
            sub_i = find(Subgraph_list{k_id} == i);
            Theta_sub = out_FPN_sub_opt{k_id}.Theta_hist(:,:, min(length(out_FPN_sub_opt{k_id}.obj_itr), iter));
            Theta_hat(i,i) = Theta_sub(sub_i, sub_i); 
        end
    end
    
    obj_FPN_bbd = [obj_FPN_bbd objective_function(Theta_hat, S_lambda).value];
end


